/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.config.Config;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.deploy.util.WinRegistry;
import com.sun.javaws.OperaPreferences;
import com.sun.javaws.OperaSupport;
import java.io.File;
import java.io.IOException;

public class WinOperaSupport
extends OperaSupport {
    private static final String OPERA_SUBKEY = "Software\\Microsoft\\Windows\\CurrentVersion\\App Paths\\Opera.exe";
    private static final String OPERA_PATH = "Path";
    private static final String USER_HOME = "user.home";
    private static final String USER_DATA_INFIX = "Application Data" + File.separator + "Opera";
    private static final String USER_DATA_POSTFIX = "Profile";
    private static final String SYSTEM_PREFERENCES = "OperaDef6.ini";
    private static final String MULTI_USER_SECTION = "System";
    private static final String MULTI_USER_KEY = "Multi User";

    public boolean isInstalled() {
        return this.getInstallPath().length() != 0;
    }

    public void enableJnlp(File file, boolean bl) {
        String string = this.getInstallPath();
        if (string.length() > 0) {
            try {
                File file2 = new File(string);
                File file3 = this.enableSystemJnlp(file2, file);
                if (file3 == null && !(file3 = new File(file2, "Opera6.ini")).exists() && !(file3 = new File(file2, "Opera.ini")).exists()) {
                    file3 = new File(Config.getOSHome(), "Opera.ini");
                }
                this.enableJnlp(null, file3, file, bl);
            }
            catch (Exception exception) {
                Trace.ignoredException((Exception)exception);
            }
        }
    }

    public WinOperaSupport(boolean bl) {
        super(bl);
    }

    private File enableSystemJnlp(File file, File file2) throws IOException {
        OperaPreferences operaPreferences = null;
        File file3 = null;
        File file4 = null;
        file3 = new File(file, SYSTEM_PREFERENCES);
        operaPreferences = this.getPreferences(file3);
        if (operaPreferences != null) {
            CharSequence charSequence;
            boolean bl = true;
            this.enableJnlp(operaPreferences, file3, file2, true);
            if (operaPreferences.containsKey(MULTI_USER_SECTION, MULTI_USER_KEY)) {
                charSequence = operaPreferences.get(MULTI_USER_SECTION, MULTI_USER_KEY).trim();
                charSequence = ((String)charSequence).substring(0, ((String)charSequence).indexOf(32));
                try {
                    int n = Integer.decode((String)charSequence);
                    if (n == 0) {
                        bl = false;
                        Trace.println((String)("Multi-user support is turned off in the Opera system preference file (" + file3.getAbsolutePath() + ")."), (TraceLevel)TraceLevel.BASIC);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                    Trace.println((String)("The Opera system preference file (" + file3.getAbsolutePath() + ") has '" + MULTI_USER_KEY + "=" + (String)charSequence + "' in the " + MULTI_USER_SECTION + " section, so multi-user " + "support is not enabled."), (TraceLevel)TraceLevel.BASIC);
                }
            }
            if (bl) {
                charSequence = new StringBuffer(512);
                ((StringBuffer)charSequence).append(System.getProperty(USER_HOME)).append(File.separator).append(USER_DATA_INFIX).append(File.separator).append(file.getName()).append(File.separator).append(USER_DATA_POSTFIX).append(File.separator).append("Opera6.ini");
                file4 = new File(((StringBuffer)charSequence).toString());
            }
        }
        return file4;
    }

    private String getInstallPath() {
        String string = WinRegistry.getString((int)-2147483646, (String)OPERA_SUBKEY, (String)OPERA_PATH);
        return string != null ? string : "";
    }
}

