/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.dom.core;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;
import sun.plugin.dom.DOMImplementation;
import sun.plugin.dom.DOMObject;
import sun.plugin.dom.DOMObjectFactory;
import sun.plugin.dom.DOMObjectHelper;
import sun.plugin.dom.exception.NoModificationAllowedException;
import sun.plugin.dom.exception.PluginNotSupportedException;

public abstract class Node
implements org.w3c.dom.Node {
    private static final String ATTR_CHILDREN = "children";
    private static final String ATTR_CHILD_NODES = "childNodes";
    private static final String ATTR_PARENT_NODE = "parentNode";
    private static final String ATTR_FIRST_CHILD = "firstChild";
    private static final String ATTR_LAST_CHILD = "lastChild";
    private static final String ATTR_PREVIOUS_SIBLING = "previousSibling";
    private static final String ATTR_NEXT_SIBLING = "nextSibling";
    private static final String ATTR_HAS_CHILD_NODES = "hasChildNodes";
    private static final String FUNC_APPEND_CHILD = "appendChild";
    private static final String FUNC_CLONE_NODE = "cloneNode";
    private static final String FUNC_INSERT_BEFORE = "insertBefore";
    private static final String FUNC_REMOVE_CHILD = "removeChild";
    private static final String FUNC_REPLACE_CHILD = "replaceChild";
    private static final String FUNC_REPLACE_NODE = "replaceNode";
    protected DOMObject obj;
    private Document doc;

    protected Node(DOMObject dOMObject, Document document) {
        this.obj = dOMObject;
        this.doc = document;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Node)) {
            return false;
        }
        return this.obj.equals(((Node)object).obj);
    }

    public int hashCode() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append(this.toString());
        return stringBuffer.toString().hashCode();
    }

    public String toString() {
        if (this.obj != null) {
            return this.obj.toString();
        }
        return super.toString();
    }

    public abstract String getNodeName();

    public abstract String getNodeValue() throws DOMException;

    public abstract void setNodeValue(String var1) throws DOMException;

    public abstract short getNodeType();

    public NodeList getChildNodes() {
        Object object;
        Object object2 = null;
        try {
            object2 = this.obj.getMember(ATTR_CHILDREN);
            if (!(object2 instanceof DOMObject)) {
                object2 = null;
            }
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        if (object2 == null) {
            object2 = this.obj.getMember(ATTR_CHILD_NODES);
        }
        if (object2 != null && object2 instanceof DOMObject && (object = DOMObjectFactory.createCommonDOMObject((DOMObject)object2, this.getOwnerDocument())) != null && object instanceof NodeList) {
            return (NodeList)object;
        }
        return null;
    }

    public org.w3c.dom.Node getParentNode() {
        Object object;
        Object object2 = this.obj.getMember(ATTR_PARENT_NODE);
        if (object2 != null && object2 instanceof DOMObject && (object = DOMObjectFactory.createCommonDOMObject((DOMObject)object2, this.getOwnerDocument())) != null && object instanceof org.w3c.dom.Node) {
            return (org.w3c.dom.Node)object;
        }
        return null;
    }

    public org.w3c.dom.Node getFirstChild() {
        NodeList nodeList = this.getChildNodes();
        if (nodeList != null && nodeList.getLength() > 0) {
            return nodeList.item(0);
        }
        return null;
    }

    public org.w3c.dom.Node getLastChild() {
        int n;
        NodeList nodeList = this.getChildNodes();
        if (nodeList != null && (n = nodeList.getLength()) > 0) {
            return nodeList.item(n - 1);
        }
        return null;
    }

    public org.w3c.dom.Node getPreviousSibling() {
        Object object;
        Object object2 = this.obj.getMember(ATTR_PREVIOUS_SIBLING);
        if (object2 != null && object2 instanceof DOMObject && (object = DOMObjectFactory.createCommonDOMObject((DOMObject)object2, this.getOwnerDocument())) != null && object instanceof org.w3c.dom.Node) {
            return (org.w3c.dom.Node)object;
        }
        return null;
    }

    public org.w3c.dom.Node getNextSibling() {
        Object object;
        Object object2 = this.obj.getMember(ATTR_NEXT_SIBLING);
        if (object2 != null && object2 instanceof DOMObject && (object = DOMObjectFactory.createCommonDOMObject((DOMObject)object2, this.getOwnerDocument())) != null && object instanceof org.w3c.dom.Node) {
            return (org.w3c.dom.Node)object;
        }
        return null;
    }

    public NamedNodeMap getAttributes() {
        throw new PluginNotSupportedException("Node.getAttributes() is not supported.");
    }

    public Document getOwnerDocument() {
        return this.doc;
    }

    public org.w3c.dom.Node insertBefore(org.w3c.dom.Node node, org.w3c.dom.Node node2) throws DOMException {
        if (node != null && node2 != null) {
            if (node instanceof Node && node2 instanceof Node) {
                Object object;
                Node node3 = (Node)node;
                Node node4 = (Node)node2;
                Object object2 = this.obj.call(FUNC_INSERT_BEFORE, new Object[]{node3.obj.getJSObject(), node4.obj.getJSObject()});
                if (object2 != null && object2 instanceof DOMObject && (object = DOMObjectFactory.createCommonDOMObject((DOMObject)object2, this.getOwnerDocument())) != null && object instanceof org.w3c.dom.Node) {
                    return (org.w3c.dom.Node)object;
                }
            } else {
                throw new PluginNotSupportedException("Node.insertBefore() does not support node type: (" + node.getClass().getName() + ", " + node2.getClass().getName() + ")");
            }
        }
        return null;
    }

    public org.w3c.dom.Node replaceChild(org.w3c.dom.Node node, org.w3c.dom.Node node2) throws DOMException {
        if (node != null && node2 != null) {
            if (node instanceof Node && node2 instanceof Node) {
                Object object;
                Node node3 = (Node)node;
                Node node4 = (Node)node2;
                Object object2 = this.obj.call(FUNC_REPLACE_CHILD, new Object[]{node3.obj.getJSObject(), node4.obj.getJSObject()});
                if (object2 != null && object2 instanceof DOMObject && (object = DOMObjectFactory.createCommonDOMObject((DOMObject)object2, this.getOwnerDocument())) != null && object instanceof org.w3c.dom.Node) {
                    return (org.w3c.dom.Node)object;
                }
            } else {
                throw new PluginNotSupportedException("Node.replaceChild() does not support node type: (" + node.getClass().getName() + ", " + node2.getClass().getName() + ")");
            }
        }
        return null;
    }

    public org.w3c.dom.Node removeChild(org.w3c.dom.Node node) throws DOMException {
        if (node != null) {
            if (node instanceof Node) {
                Object object;
                Node node2 = (Node)node;
                Object object2 = this.obj.call(FUNC_REMOVE_CHILD, new Object[]{node2.obj.getJSObject()});
                if (object2 != null && object2 instanceof DOMObject && (object = DOMObjectFactory.createCommonDOMObject((DOMObject)object2, this.getOwnerDocument())) != null && object instanceof org.w3c.dom.Node) {
                    return (org.w3c.dom.Node)object;
                }
            } else {
                throw new PluginNotSupportedException("Node.removeChild() does not support node type: " + node.getClass().getName());
            }
        }
        return null;
    }

    public org.w3c.dom.Node appendChild(org.w3c.dom.Node node) throws DOMException {
        if (node != null) {
            if (node instanceof Node) {
                Object object;
                Node node2 = (Node)node;
                Object object2 = this.obj.call(FUNC_APPEND_CHILD, new Object[]{node2.obj.getJSObject()});
                if (object2 != null && object2 instanceof DOMObject && (object = DOMObjectFactory.createCommonDOMObject((DOMObject)object2, this.getOwnerDocument())) != null && object instanceof org.w3c.dom.Node) {
                    return (org.w3c.dom.Node)object;
                }
            } else {
                throw new PluginNotSupportedException("Node.appendChild() does not support node type: " + node.getClass().getName());
            }
        }
        return null;
    }

    public boolean hasChildNodes() {
        return DOMObjectHelper.getBooleanMember(this.obj, ATTR_HAS_CHILD_NODES);
    }

    public org.w3c.dom.Node cloneNode(boolean bl) {
        Object object;
        Object object2 = this.obj.call(FUNC_CLONE_NODE, new Object[]{new Boolean(bl)});
        if (object2 != null && object2 instanceof DOMObject && (object = DOMObjectFactory.createCommonDOMObject((DOMObject)object2, this.getOwnerDocument())) != null && object instanceof org.w3c.dom.Node) {
            ((DOMObject)object2).lock();
            return (org.w3c.dom.Node)object;
        }
        return null;
    }

    public void normalize() {
        throw new PluginNotSupportedException("Node.normalize() is not supported.");
    }

    public boolean isSupported(String string, String string2) {
        DOMImplementation dOMImplementation = new DOMImplementation();
        return dOMImplementation.hasFeature(string, string2);
    }

    public String getNamespaceURI() {
        throw new PluginNotSupportedException("Node.getNamespaceURI() is not supported.");
    }

    public String getPrefix() {
        throw new PluginNotSupportedException("Node.getPrefix() is not supported.");
    }

    public void setPrefix(String string) throws DOMException {
        throw new NoModificationAllowedException("Node.setPrefix() is not supported");
    }

    public String getLocalName() {
        throw new PluginNotSupportedException("Node.getLocalName() is not supported.");
    }

    public boolean hasAttributes() {
        throw new PluginNotSupportedException("Node.hasAttributes() is not supported.");
    }

    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        throw new PluginNotSupportedException("Node.setUserData() is not supported.");
    }

    public Object getUserData(String string) {
        throw new PluginNotSupportedException("Node.getUserData() is not supported.");
    }

    public Object getFeature(String string, String string2) {
        throw new PluginNotSupportedException("Node.getFeature() is not supported.");
    }

    public boolean isSameNode(org.w3c.dom.Node node) {
        throw new PluginNotSupportedException("Node.isSameNode() is not supported.");
    }

    public boolean isEqualNode(org.w3c.dom.Node node) {
        throw new PluginNotSupportedException("Node.isEqualNode() is not supported.");
    }

    public String lookupNamespaceURI(String string) {
        throw new PluginNotSupportedException("Node.lookupNamespaceURI() is not supported.");
    }

    public boolean isDefaultNamespace(String string) {
        throw new PluginNotSupportedException("Node.isDefaultNamespace() is not supported.");
    }

    public String lookupPrefix(String string) {
        throw new PluginNotSupportedException("Node.lookupPrefix() is not supported.");
    }

    public String getTextContent() throws DOMException {
        throw new PluginNotSupportedException("Node.getTextContent() is not supported.");
    }

    public void setTextContent(String string) throws DOMException {
        throw new PluginNotSupportedException("Node.setTextContent() is not supported.");
    }

    public short compareDocumentPosition(org.w3c.dom.Node node) throws DOMException {
        throw new PluginNotSupportedException("Node.compareDocumentPosition() is not supported.");
    }

    public String getBaseURI() {
        throw new PluginNotSupportedException("Node.getBaseURI() is not supported.");
    }
}

