/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.dtm;

import com.sun.org.apache.xml.internal.dtm.SecuritySupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;

class FactoryFinder {
    private static boolean debug;
    private static String foundFactory;

    FactoryFinder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object find(String string, String string2) throws ConfigurationError {
        Object object;
        SecuritySupport securitySupport = SecuritySupport.getInstance();
        ClassLoader classLoader = FactoryFinder.class.getClassLoader();
        FactoryFinder.dPrint("find factoryId=" + string);
        try {
            object = securitySupport.getSystemProperty(string);
            if (object != null) {
                FactoryFinder.dPrint("found system property, value=" + (String)object);
                return FactoryFinder.newInstance((String)object, classLoader, true);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        object = FactoryFinder.class;
        synchronized (FactoryFinder.class) {
            if (foundFactory == null) {
                Properties properties = null;
                try {
                    String string3 = securitySupport.getSystemProperty("java.home");
                    String string4 = string3 + File.separator + "lib" + File.separator + "xalan.properties";
                    File file = new File(string4);
                    FileInputStream fileInputStream = securitySupport.getFileInputStream(file);
                    properties = new Properties();
                    properties.load(fileInputStream);
                    fileInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (properties != null) {
                    foundFactory = properties.getProperty(string);
                    if (foundFactory != null) {
                        FactoryFinder.dPrint("found in xalan.properties, value=" + foundFactory);
                    }
                } else {
                    FactoryFinder.findJarServiceProvider(string);
                    if (foundFactory == null) {
                        if (string2 == null) {
                            throw new ConfigurationError("Provider for " + string + " cannot be found", null);
                        }
                        FactoryFinder.dPrint("using fallback, value=" + string2);
                        foundFactory = string2;
                    }
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return FactoryFinder.newInstance(foundFactory, classLoader, true);
        }
    }

    private static void dPrint(String string) {
        if (debug) {
            System.err.println("JAXP: " + string);
        }
    }

    private static Object newInstance(String string, ClassLoader classLoader, boolean bl) throws ConfigurationError {
        try {
            Class<?> clazz;
            if (classLoader == null) {
                clazz = Class.forName(string);
            } else {
                try {
                    clazz = classLoader.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (bl) {
                        classLoader = FactoryFinder.class.getClassLoader();
                        clazz = classLoader.loadClass(string);
                    }
                    throw classNotFoundException;
                }
            }
            Object obj = clazz.newInstance();
            FactoryFinder.dPrint("created new instance of " + clazz + " using ClassLoader: " + classLoader);
            return obj;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigurationError("Provider " + string + " not found", classNotFoundException);
        }
        catch (Exception exception) {
            throw new ConfigurationError("Provider " + string + " could not be instantiated: " + exception, exception);
        }
    }

    private static String findJarServiceProvider(String string) throws ConfigurationError {
        BufferedReader bufferedReader;
        SecuritySupport securitySupport = SecuritySupport.getInstance();
        String string2 = "META-INF/services/" + string;
        InputStream inputStream = null;
        ClassLoader classLoader = FactoryFinder.class.getClassLoader();
        inputStream = securitySupport.getResourceAsStream(classLoader, string2);
        if (inputStream == null) {
            return null;
        }
        FactoryFinder.dPrint("found jar resource=" + string2 + " using ClassLoader: " + classLoader);
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        }
        String string3 = null;
        try {
            string3 = bufferedReader.readLine();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            return null;
        }
        if (string3 != null && !"".equals(string3)) {
            FactoryFinder.dPrint("found in resource, value=" + string3);
            return string3;
        }
        return null;
    }

    static {
        foundFactory = null;
        try {
            String string = SecuritySupport.getInstance().getSystemProperty("jaxp.debug");
            debug = string != null && !"false".equals(string);
        }
        catch (SecurityException securityException) {
            debug = false;
        }
    }

    static class ConfigurationError
    extends Error {
        private Exception exception;

        ConfigurationError(String string, Exception exception) {
            super(string);
            this.exception = exception;
        }

        Exception getException() {
            return this.exception;
        }
    }
}

