/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.CharArrayWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.security.AccessController;
import java.util.BitSet;
import sun.security.action.GetPropertyAction;

public class URLEncoder {
    static BitSet dontNeedEncoding;
    static final int caseDiff = 32;
    static String dfltEncName;

    private URLEncoder() {
    }

    @Deprecated
    public static String encode(String string) {
        String string2 = null;
        try {
            string2 = URLEncoder.encode(string, dfltEncName);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string2;
    }

    public static String encode(String string, String string2) throws UnsupportedEncodingException {
        Charset charset;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        if (string2 == null) {
            throw new NullPointerException("charsetName");
        }
        try {
            charset = Charset.forName(string2);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            throw new UnsupportedEncodingException(string2);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            throw new UnsupportedEncodingException(string2);
        }
        int n = 0;
        while (n < string.length()) {
            char c;
            int n2 = string.charAt(n);
            if (dontNeedEncoding.get(n2)) {
                if (n2 == 32) {
                    n2 = 43;
                    bl = true;
                }
                stringBuffer.append((char)n2);
                ++n;
                continue;
            }
            do {
                char c2;
                charArrayWriter.write(n2);
                if (n2 >= 55296 && n2 <= 56319 && n + 1 < string.length() && (c2 = string.charAt(n + 1)) >= '\udc00' && c2 <= '\udfff') {
                    charArrayWriter.write(c2);
                    ++n;
                }
                if (++n >= string.length()) break;
                c = string.charAt(n);
                n2 = c;
            } while (!dontNeedEncoding.get(c));
            charArrayWriter.flush();
            String string3 = new String(charArrayWriter.toCharArray());
            byte[] byArray = string3.getBytes(charset.name());
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append('%');
                char c3 = Character.forDigit(byArray[i] >> 4 & 0xF, 16);
                if (Character.isLetter(c3)) {
                    c3 = (char)(c3 - 32);
                }
                stringBuffer.append(c3);
                c3 = Character.forDigit(byArray[i] & 0xF, 16);
                if (Character.isLetter(c3)) {
                    c3 = (char)(c3 - 32);
                }
                stringBuffer.append(c3);
            }
            charArrayWriter.reset();
            bl = true;
        }
        return bl ? stringBuffer.toString() : string;
    }

    static {
        int n;
        dfltEncName = null;
        dontNeedEncoding = new BitSet(256);
        for (n = 97; n <= 122; ++n) {
            dontNeedEncoding.set(n);
        }
        for (n = 65; n <= 90; ++n) {
            dontNeedEncoding.set(n);
        }
        for (n = 48; n <= 57; ++n) {
            dontNeedEncoding.set(n);
        }
        dontNeedEncoding.set(32);
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
        dfltEncName = (String)AccessController.doPrivileged(new GetPropertyAction("file.encoding"));
    }
}

