/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelayQueue<E extends Delayed>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    private final transient ReentrantLock lock = new ReentrantLock();
    private final transient Condition available = this.lock.newCondition();
    private final PriorityQueue<E> q = new PriorityQueue();

    public DelayQueue() {
    }

    public DelayQueue(Collection<? extends E> collection) {
        this.addAll(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Delayed delayed = (Delayed)this.q.peek();
            this.q.offer(e);
            if (delayed == null || e.compareTo((Delayed)delayed) < 0) {
                this.available.signalAll();
            }
            boolean bl = true;
            Object var6_5 = null;
            reentrantLock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    @Override
    public void put(E e) {
        this.offer(e);
    }

    @Override
    public boolean offer(E e, long l, TimeUnit timeUnit) {
        return this.offer(e);
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public E take() throws InterruptedException {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        try {
            while (true) {
                Delayed delayed2;
                if ((delayed2 = (Delayed)this.q.peek()) == null) {
                    this.available.await();
                    continue;
                }
                long l = delayed2.getDelay(TimeUnit.NANOSECONDS);
                if (l <= 0L) break;
                long l2 = this.available.awaitNanos(l);
            }
            Delayed delayed3 = (Delayed)this.q.poll();
            assert (delayed3 != null);
            if (this.q.size() != 0) {
                this.available.signalAll();
            }
            Delayed delayed = delayed3;
            Object var8_7 = null;
            reentrantLock.unlock();
            return (E)delayed;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public E poll(long l, TimeUnit timeUnit) throws InterruptedException {
        Delayed delayed;
        ReentrantLock reentrantLock;
        block10: {
            E e;
            block9: {
                reentrantLock = this.lock;
                reentrantLock.lockInterruptibly();
                long l2 = timeUnit.toNanos(l);
                try {
                    while (true) {
                        Delayed delayed2;
                        if ((delayed2 = (Delayed)this.q.peek()) == null) {
                            if (l2 <= 0L) {
                                E e2 = null;
                                Object var13_11 = null;
                                reentrantLock.unlock();
                                return e2;
                            }
                            l2 = this.available.awaitNanos(l2);
                            continue;
                        }
                        long l3 = delayed2.getDelay(TimeUnit.NANOSECONDS);
                        if (l3 <= 0L) break;
                        if (l2 <= 0L) {
                            e = null;
                            break block9;
                        }
                        if (l3 > l2) {
                            l3 = l2;
                        }
                        long l4 = this.available.awaitNanos(l3);
                        l2 -= l3 - l4;
                    }
                    Delayed delayed3 = (Delayed)this.q.poll();
                    assert (delayed3 != null);
                    if (this.q.size() != 0) {
                        this.available.signalAll();
                    }
                    delayed = delayed3;
                    break block10;
                }
                catch (Throwable throwable) {
                    Object var13_14 = null;
                    reentrantLock.unlock();
                    throw throwable;
                }
            }
            Object var13_12 = null;
            reentrantLock.unlock();
            return e;
        }
        Object var13_13 = null;
        reentrantLock.unlock();
        return (E)delayed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        ReentrantLock reentrantLock;
        block5: {
            E e;
            reentrantLock = this.lock;
            reentrantLock.lock();
            try {
                Delayed delayed = (Delayed)this.q.peek();
                if (delayed != null && delayed.getDelay(TimeUnit.NANOSECONDS) <= 0L) break block5;
                e = null;
                Object var6_5 = null;
                reentrantLock.unlock();
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                reentrantLock.unlock();
                throw throwable;
            }
            return e;
        }
        Delayed delayed = (Delayed)this.q.poll();
        assert (delayed != null);
        if (this.q.size() != 0) {
            this.available.signalAll();
        }
        Delayed delayed2 = delayed;
        Object var6_6 = null;
        reentrantLock.unlock();
        return (E)delayed2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        Delayed delayed;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            delayed = (Delayed)this.q.peek();
            Object var4_3 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        return (E)delayed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.q.size();
            Object var4_3 = null;
            reentrantLock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Delayed delayed;
            int n = 0;
            while ((delayed = (Delayed)this.q.peek()) != null && delayed.getDelay(TimeUnit.NANOSECONDS) <= 0L) {
                collection.add(this.q.poll());
                ++n;
            }
            if (n > 0) {
                this.available.signalAll();
            }
            int n2 = n;
            Object var6_6 = null;
            reentrantLock.unlock();
            return n2;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> collection, int n) {
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        if (n <= 0) {
            return 0;
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Delayed delayed;
            int n2;
            for (n2 = 0; n2 < n && (delayed = (Delayed)this.q.peek()) != null && delayed.getDelay(TimeUnit.NANOSECONDS) <= 0L; ++n2) {
                collection.add(this.q.poll());
            }
            if (n2 > 0) {
                this.available.signalAll();
            }
            int n3 = n2;
            Object var7_7 = null;
            reentrantLock.unlock();
            return n3;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            this.q.clear();
            Object var3_2 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Object[] objectArray = this.q.toArray();
            Object var4_3 = null;
            reentrantLock.unlock();
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] TArray) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            T[] TArray2 = this.q.toArray(TArray);
            Object var5_4 = null;
            reentrantLock.unlock();
            return TArray2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = this.q.remove(object);
            Object var5_4 = null;
            reentrantLock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<E> iterator() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Itr<E> itr = new Itr<E>(this.q.iterator());
            Object var4_3 = null;
            reentrantLock.unlock();
            return itr;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Itr<E>
    implements Iterator<E> {
        private final Iterator<E> iter;

        Itr(Iterator<E> iterator) {
            this.iter = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() {
            E e;
            ReentrantLock reentrantLock = DelayQueue.this.lock;
            reentrantLock.lock();
            try {
                e = this.iter.next();
                Object var4_3 = null;
                reentrantLock.unlock();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                reentrantLock.unlock();
                throw throwable;
            }
            return e;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            ReentrantLock reentrantLock = DelayQueue.this.lock;
            reentrantLock.lock();
            try {
                this.iter.remove();
                Object var3_2 = null;
                reentrantLock.unlock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                reentrantLock.unlock();
                throw throwable;
            }
        }
    }
}

