/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.imageio.stream.ImageOutputStreamImpl;

public class FileImageOutputStream
extends ImageOutputStreamImpl {
    private RandomAccessFile raf;

    public FileImageOutputStream(File file) throws FileNotFoundException, IOException {
        this(file == null ? null : new RandomAccessFile(file, "rw"));
    }

    public FileImageOutputStream(RandomAccessFile randomAccessFile) {
        if (randomAccessFile == null) {
            throw new IllegalArgumentException("raf == null!");
        }
        this.raf = randomAccessFile;
    }

    public int read() throws IOException {
        this.checkClosed();
        this.bitOffset = 0;
        int n = this.raf.read();
        if (n != -1) {
            ++this.streamPos;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.checkClosed();
        this.bitOffset = 0;
        int n3 = this.raf.read(byArray, n, n2);
        if (n3 != -1) {
            this.streamPos += (long)n3;
        }
        return n3;
    }

    public void write(int n) throws IOException {
        this.checkClosed();
        this.flushBits();
        this.raf.write(n);
        ++this.streamPos;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.checkClosed();
        this.flushBits();
        this.raf.write(byArray, n, n2);
        this.streamPos += (long)n2;
    }

    public long length() {
        try {
            this.checkClosed();
            return this.raf.length();
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    public void seek(long l) throws IOException {
        this.checkClosed();
        if (l < this.flushedPos) {
            throw new IndexOutOfBoundsException("pos < flushedPos!");
        }
        this.bitOffset = 0;
        this.raf.seek(l);
        this.streamPos = this.raf.getFilePointer();
    }

    public void close() throws IOException {
        super.close();
        this.raf.close();
    }
}

