/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanInfo;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import sun.tools.jconsole.MBeansTab;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.inspector.ThreadDialog;
import sun.tools.jconsole.inspector.Utils;
import sun.tools.jconsole.inspector.XDataViewer;
import sun.tools.jconsole.inspector.XMBean;
import sun.tools.jconsole.inspector.XMBeanAttributes;
import sun.tools.jconsole.inspector.XMBeanInfo;
import sun.tools.jconsole.inspector.XMBeanNotifications;
import sun.tools.jconsole.inspector.XMBeanOperations;
import sun.tools.jconsole.inspector.XMBeanTree;
import sun.tools.jconsole.inspector.XPane;
import sun.tools.jconsole.inspector.XTabbedPane;

public class XSheet
extends JPanel
implements ActionListener,
NotificationListener,
ChangeListener {
    private JComponent lastPanel;
    private XMBean mbean;
    private XMBeanPane mbeanPane;
    private XPane objectPane;
    private XPane arrayPane;
    protected XMBeanTree mbeanTree;
    private JButton refreshButton;
    private JButton clearButton;
    private JButton subscribeButton;
    private JButton unsubscribeButton;
    private HashMap<XMBean, Integer> tabIndex = new HashMap();
    protected int currentType = -1;
    protected static final int MBEAN = 1;
    protected static final int OBJECT = 2;
    protected static final int ARRAY = 3;
    private XDataViewer viewer;
    private JPanel south;
    private MBeansTab mbeansTab;
    private JFrame window = new JFrame();

    public XSheet(XMBeanTree xMBeanTree, XDataViewer xDataViewer, MBeansTab mBeansTab) {
        this.mbeanTree = xMBeanTree;
        this.viewer = xDataViewer;
        this.mbeansTab = mBeansTab;
        xMBeanTree.getSelectionModel().setSelectionMode(1);
        this.setupScreen();
    }

    public void dispose() {
        if (this.mbeanPane != null) {
            this.mbeanPane.dispose(this.mbeansTab);
        }
    }

    private void setupScreen() {
        this.setLayout(new BorderLayout());
        this.lastPanel = new JPanel();
        this.add((Component)this.lastPanel, "Center");
        this.south = new JPanel();
        this.refreshButton = new JButton(Resources.getText("Refresh", new Object[0]));
        this.south.add((Component)this.refreshButton, "South");
        this.refreshButton.addActionListener(this);
        this.refreshButton.setEnabled(false);
        this.clearButton = new JButton(Resources.getText("Clear", new Object[0]));
        this.clearButton.addActionListener(this);
        this.subscribeButton = new JButton(Resources.getText("Subscribe", new Object[0]));
        this.subscribeButton.addActionListener(this);
        this.unsubscribeButton = new JButton(Resources.getText("Unsubscribe", new Object[0]));
        this.unsubscribeButton.addActionListener(this);
        this.add((Component)this.south, "South");
    }

    public synchronized void notificationReceived() {
        XPane xPane = this.getMBeanPane(this.mbean);
    }

    public void displaySelectedPaths(List list) {
        if (list == null) {
            this.clearCurrentPane();
        } else if (list.size() == 0) {
            this.clearCurrentPane();
        } else {
            try {
                XMBean xMBean = (XMBean)((DefaultMutableTreeNode)((TreePath)list.get(0)).getLastPathComponent()).getUserObject();
                this.display(xMBean);
            }
            catch (Throwable throwable) {
                EventQueue.invokeLater(new ThreadDialog(this, throwable.getMessage(), Resources.getText("Problem displaying MBean", new Object[0]), 0));
            }
        }
    }

    public void displaySelectedMBeans(List list) {
        if (list == null) {
            this.clearCurrentPane();
        } else if (list.size() == 0) {
            this.clearCurrentPane();
        } else {
            try {
                this.display((XMBean)list.get(0));
            }
            catch (Throwable throwable) {
                EventQueue.invokeLater(new ThreadDialog(this, throwable.getMessage(), Resources.getText("Problem displaying MBean", new Object[0]), 0));
            }
        }
    }

    private void initMBeanPane() {
        if (this.mbeanPane == null) {
            this.mbeanPane = new XMBeanPane();
            this.mbeanPane.init();
            this.mbeanPane.addChangeListener(this);
        }
    }

    protected XPane getMBeanPane(XMBean xMBean) {
        this.initMBeanPane();
        return this.mbeanPane;
    }

    protected XPane getCurrentPane() {
        if (this.currentType != -1) {
            return this.mbeanPane;
        }
        return null;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.isNotificationPaneSelected()) {
            this.south.remove(this.refreshButton);
            this.south.add((Component)this.subscribeButton, "East");
            this.south.add((Component)this.unsubscribeButton, "Center");
            this.south.add((Component)this.clearButton, "West");
        } else {
            this.south.remove(this.clearButton);
            this.south.remove(this.subscribeButton);
            this.south.remove(this.unsubscribeButton);
            this.south.add((Component)this.refreshButton, "South");
        }
        this.validate();
        this.repaint();
    }

    public void registerListener(XMBean xMBean) throws InstanceNotFoundException, IOException {
        this.mbeanPane.registerListener(xMBean);
        this.validate();
    }

    public void unregisterListener(XMBean xMBean) {
        boolean bl = this.mbeanPane.unregisterListener(xMBean);
        if (bl) {
            this.validate();
        }
    }

    public void display(final XMBean xMBean) throws Exception {
        this.mbeansTab.workerAdd(new Runnable(){

            public void run() {
                try {
                    if (XSheet.this.lastPanel instanceof XTabbedPane) {
                        int n = ((XTabbedPane)XSheet.this.lastPanel).getSelectedIndex();
                        XSheet.this.tabIndex.put(XSheet.this.mbean, n);
                    }
                    MBeanInfo mBeanInfo = xMBean.getMBeanInfo();
                    XSheet.this.currentType = 1;
                    XSheet.this.initMBeanPane();
                    XSheet.this.mbeanPane.load(xMBean, mBeanInfo);
                    JComponent jComponent = null;
                    jComponent = XSheet.this.lastPanel != XSheet.this.mbeanPane ? XSheet.this.mbeanPane : XSheet.this.lastPanel;
                    if (XSheet.this.tabIndex.containsKey(xMBean)) {
                        int n = (Integer)XSheet.this.tabIndex.get(xMBean);
                        ((XMBeanPane)jComponent).setSelectedIndex(n, false);
                    } else {
                        ((XMBeanPane)jComponent).setSelectedIndex(0, false);
                        XSheet.this.tabIndex.put(xMBean, 0);
                    }
                    XSheet.this.mbeanPane.enableNotifications(xMBean);
                    XSheet.this.mbean = xMBean;
                }
                catch (Throwable throwable) {
                    EventQueue.invokeLater(new ThreadDialog(XSheet.this, throwable.getMessage(), Resources.getText("Problem displaying MBean", new Object[0]), 0));
                }
                XSheet.this.updatePanel(XSheet.this.mbeanPane);
            }
        });
    }

    private void updatePanel(JComponent jComponent) {
        if (this.lastPanel != jComponent) {
            this.invalidate();
            this.remove(this.lastPanel);
            this.lastPanel = jComponent;
            this.add((Component)this.lastPanel, "Center");
            this.validate();
        }
        this.mbeanPane.enable();
        this.refreshButton.setEnabled(true);
        this.validateTree();
        this.repaint();
    }

    private boolean isNotificationPaneSelected() {
        return this.mbeanPane.isNotificationPaneSelected();
    }

    private void clearCurrentPane() {
        if (this.currentType != -1) {
            this.mbean = null;
            this.invalidate();
            this.mbeanPane.disable();
            this.refreshButton.setEnabled(false);
            this.getCurrentPane().clear();
            this.tabIndex.clear();
            this.currentType = -1;
            this.validateTree();
            this.repaint();
        }
    }

    public void refreshCurrentTable() {
        try {
            if (this.currentType != -1) {
                this.getCurrentPane().refresh();
            }
        }
        catch (IOException iOException) {
            System.out.println("Error while refreshing :" + iOException.toString());
        }
    }

    public void displayInWindow(Component component, Component component2, String string) {
        try {
            this.window.getContentPane().getComponent(0);
            this.window.getContentPane().remove(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JPanel jPanel = new JPanel();
        this.window.getContentPane().add(jPanel.add(component2));
        this.window.setTitle(string);
        int n = component2.getPreferredSize().getWidth() > 200.0 ? (int)component2.getPreferredSize().getWidth() : 200;
        int n2 = component2.getPreferredSize().getHeight() > 150.0 ? (int)component2.getPreferredSize().getHeight() : 150;
        Dimension dimension = new Dimension(n + 20, n2 + 20);
        this.window.setPreferredSize(dimension);
        this.window.setLocationRelativeTo(component);
        this.window.pack();
        this.window.setVisible(true);
    }

    public void handleNotification(Notification notification, Object object) {
        if (notification.getType().equals("jam.xmbean.selection.changed")) {
            this.displaySelectedPaths((List)object);
        } else if (notification.getType().equals("jam.xmbean.value.update")) {
            XMBean xMBean = (XMBean)object;
            if (xMBean.equals(this.mbean)) {
                this.refreshCurrentTable();
            }
        } else if (notification.getType().equals("jam.xoperations.invoke.result")) {
            Component component;
            if (object != null && (component = this.viewer.createOperationViewer(object, this.mbean)) != null) {
                this.displayInWindow((Component)notification.getSource(), component, Resources.getText("Operation return value", new Object[0]));
                return;
            }
            JOptionPane.showMessageDialog(this, object == null ? "null" : object, Resources.getText("Operation return value", new Object[0]), 1);
            this.refreshCurrentTable();
        } else if (notification.getType().equals("jconsole.xnotification.received")) {
            XMBean xMBean = (XMBean)object;
            Long l = (Long)notification.getUserData();
            if (xMBean.equals(this.mbean)) {
                this.mbeanPane.updateReceivedNotifications(l);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == this.refreshButton) {
                this.mbeansTab.workerAdd(new Runnable(){

                    public void run() {
                        XSheet.this.refreshCurrentTable();
                    }
                });
                return;
            }
            if (jButton == this.clearButton) {
                this.clearCurrentNotifications();
                return;
            }
            if (jButton == this.subscribeButton) {
                this.mbeansTab.workerAdd(new Runnable(){

                    public void run() {
                        try {
                            XSheet.this.registerListener(XSheet.this.mbean);
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = Utils.getActualException(throwable);
                            EventQueue.invokeLater(new ThreadDialog(XSheet.this, throwable2.getMessage(), Resources.getText("Problem adding listener", new Object[0]), 0));
                        }
                    }
                });
                return;
            }
            if (jButton == this.unsubscribeButton) {
                this.mbeansTab.workerAdd(new Runnable(){

                    public void run() {
                        try {
                            XSheet.this.unregisterListener(XSheet.this.mbean);
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = Utils.getActualException(throwable);
                            EventQueue.invokeLater(new ThreadDialog(XSheet.this, throwable2.getMessage(), Resources.getText("Problem adding listener", new Object[0]), 0));
                        }
                    }
                });
                return;
            }
        }
    }

    private void clearCurrentNotifications() {
        this.mbeanPane.clearCurrentNotifications();
    }

    protected XSheet getSheet() {
        return this;
    }

    protected class XMBeanPane
    extends XPane {
        private XMBeanAttributes mbeanAttributes;
        private XMBeanOperations mbeanOperations;
        private XMBeanNotifications mbeanNotifications;
        private XMBeanInfo mbeanInformations;
        private boolean[] loadedIndexes;
        private XMBean mbean;
        private MBeanInfo mbeanInfo;

        protected XMBeanPane() {
        }

        public void disable() {
            this.setEnabledAt(0, false);
            this.setEnabledAt(1, false);
            this.disableNotifications();
            this.setEnabledAt(3, false);
        }

        public void dispose(MBeansTab mBeansTab) {
            XDataViewer.dispose(mBeansTab);
            this.mbeanNotifications.dispose();
        }

        public void enable() {
            this.setEnabledAt(0, this.mbeanInfo.getAttributes().length > 0);
            this.setEnabledAt(1, this.mbeanInfo.getOperations().length > 0);
            this.setEnabledAt(3, true);
        }

        private void disableNotifications() {
            this.clearNotifications();
            this.mbeanNotifications.disableNotifications();
        }

        public void clearCurrentNotifications() {
            if (this.mbeanNotifications.clearCurrentNotifications()) {
                this.setTitleAt(2, Resources.getText("Notifications", new Object[0]) + "[0]");
            }
        }

        public boolean isNotificationPaneSelected() {
            int n = this.getSelectedIndex();
            return n == 2;
        }

        public void enableNotifications(XMBean xMBean) {
            if (xMBean.isBroadcaster()) {
                this.setEnabledAt(2, true);
                if (this.mbeanNotifications.isListenerRegistered(xMBean)) {
                    long l = this.getReceivedNotifications(xMBean);
                    this.setTitleAt(2, Resources.getText("Notifications", new Object[0]) + "[" + l + "]");
                } else {
                    this.setTitleAt(2, Resources.getText("Notifications", new Object[0]));
                }
            } else {
                this.clearNotifications();
            }
        }

        private void clearNotifications() {
            this.setEnabledAt(2, false);
            this.setTitleAt(2, Resources.getText("Notifications", new Object[0]));
        }

        public void init() {
            this.mbeanAttributes = new XMBeanAttributes(XSheet.this.viewer, XSheet.this.mbeansTab);
            this.add(Resources.getText("Attributes", new Object[0]), new JScrollPane(this.mbeanAttributes));
            this.mbeanOperations = new XMBeanOperations(XSheet.this.mbeansTab);
            this.add(Resources.getText("Operations", new Object[0]), new JScrollPane(this.mbeanOperations));
            this.mbeanOperations.addOperationsListener(XSheet.this.getSheet());
            this.mbeanNotifications = new XMBeanNotifications();
            this.add(Resources.getText("Notifications", new Object[0]), new JScrollPane(this.mbeanNotifications));
            this.mbeanNotifications.addNotificationsListener(XSheet.this.getSheet());
            this.mbeanInformations = new XMBeanInfo();
            this.add(Resources.getText("Info", new Object[0]), new JScrollPane(this.mbeanInformations));
        }

        public void setSelectedIndex(int n) {
            this.setSelectedIndex(n, true);
        }

        public void setSelectedIndex(final int n, boolean bl) {
            if (bl) {
                XSheet.this.mbeansTab.workerAdd(new Runnable(){

                    public void run() {
                        XMBeanPane.this.setSelectedIndex(n, XMBeanPane.this.mbean, XMBeanPane.this.mbeanInfo);
                    }
                });
            } else {
                this.setSelectedIndex(n, this.mbean, this.mbeanInfo);
            }
        }

        private void setSelectedIndex(int n, XMBean xMBean, MBeanInfo mBeanInfo) {
            this.load(n, xMBean, mBeanInfo);
            super.setSelectedIndex(n);
        }

        public void load(int n, XMBean xMBean, MBeanInfo mBeanInfo) {
            try {
                if (xMBean == null) {
                    return;
                }
                if (this.loadedIndexes[n]) {
                    return;
                }
                if (n == 0) {
                    this.mbeanAttributes.loadAttributes(xMBean, mBeanInfo);
                } else if (n == 1) {
                    this.mbeanOperations.loadOperations(xMBean, mBeanInfo);
                } else if (n == 2) {
                    this.mbeanNotifications.loadNotifications(xMBean);
                } else if (n == 3) {
                    this.mbeanInformations.loadInfo(xMBean, mBeanInfo);
                }
                this.loadedIndexes[n] = true;
            }
            catch (Throwable throwable) {
                EventQueue.invokeLater(new ThreadDialog(this, throwable.getMessage(), Resources.getText("Problem displaying MBean", new Object[0]), 0));
            }
        }

        void updateReceivedNotifications(long l) {
            this.setTitleAt(2, Resources.getText("Notifications", new Object[0]) + "[" + l + "]");
        }

        public void load(XMBean xMBean, MBeanInfo mBeanInfo) {
            this.mbean = xMBean;
            this.mbeanInfo = mBeanInfo;
            this.loadedIndexes = new boolean[4];
        }

        public void registerListener(XMBean xMBean) throws InstanceNotFoundException, IOException {
            this.mbeanNotifications.registerListener(xMBean);
            this.enableNotifications(xMBean);
        }

        public boolean unregisterListener(XMBean xMBean) {
            boolean bl = this.mbeanNotifications.unregisterListener(xMBean);
            if (bl) {
                this.setTitleAt(2, Resources.getText("Notifications", new Object[0]));
            }
            return bl;
        }

        public long getReceivedNotifications(XMBean xMBean) {
            return this.mbeanNotifications.getReceivedNotifications(xMBean);
        }

        public void clear() {
            this.mbeanAttributes.emptyTable();
            this.mbeanAttributes.removeAttributes();
            this.mbeanOperations.removeOperations();
            this.mbeanNotifications.emptyTable();
            this.mbeanInformations.emptyTable();
            this.mbean = null;
        }

        public void refresh() throws IOException {
            this.mbeanAttributes.refreshAttributes();
        }
    }
}

